<!--
;
; BaudTec Corporation
;
; --------------------------------------------------------------------------------
; Rev   Name    Date    Description
; --------------------------------------------------------------------------------
; R00   BAU-MCL 130611  Initial version.
; R01   BAU-MCL 130611  [Bug Fixed]
; 			'IP Pool Range' will not change automatically after change
; 			'LAN IP'. 
; R02   BAU-MCL 130814  [Bug Fixed]
; 			'IP Pool Range' will not change automatically after change
; 			'LAN IP'. 
; R03	BAU-MCL	130814	[Feature Enhancement]
; 			Support one message page, tell user how the PC get new IP address. 
; R04	BAU-MCL	130925	[Bug Fixed]
; 			For example, DHCP IP Pool Range will be 192.168.100.33 - 
; 			192.168.100.254 if you change LAN IP Address from 
; 			192.168.1.1 to 192.168.10.1 . 
; 
-->

<html>
<! Copyright (c) Realtek Semiconductor Corp., 2003. All Rights Reserved. ->
<HEAD><link rel="stylesheet" href="style/normal_ws.css" type="text/css">
<meta http-equiv="Content-Type" content="text/html" charset="utf-8">
<title>LAN Interface Settings</title>
<script type="text/javascript" src="share.js">
</script>
<SCRIPT>

function resetClick()
{
	document.tcpip.reset;
}

// R03 - start
function windowStop()
{
	if (window.stop)
		window.stop(); // Chrome and Firefox
	else
		document.execCommand("Stop"); // IE
}
// R03 - end

function saveChanges()
{
	//modDhcpCfg(); // R02
	//if (!checkHostIP(document.tcpip.ip, 1))
	//	return false;

	if (!checkHostIP(document.tcpip.webLanIp, 1))
	{
		return false;
	}
	
  var vIpSegment123 = GetIpSegment123(document.tcpip.webLanIp.value);
	if(document.tcpip.mask.value != "255.255.255.0")
  {
  	calculate(document.tcpip);
  }
  else
  {
    if( !StrContains(document.tcpip.WebDhcpRangeStart.value, vIpSegment123))
    {
    	alert('Invalid IP Pool Start Range');
      document.tcpip.WebDhcpRangeStart.focus();
      return false;
    }
    
    if( !StrContains(document.tcpip.WebDhcpRangeEnd.value, vIpSegment123))
    {
    	alert('Invalid IP Pool End Range');
      document.tcpip.WebDhcpRangeEnd.focus();
      return false;
    }
  }
  
  document.tcpip.dhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.value;
	document.tcpip.dhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.value;
	document.tcpip.dhcpSubnetMask.value = document.tcpip.mask.value;
	document.tcpip.ip.value = document.tcpip.webLanIp.value;

	if (!checkNetmask(document.tcpip.mask, 1))
		return false;
	if (document.tcpip.enable_ip2.checked) {
	if (!checkIP(document.tcpip.ip2))
		return false;
	if (!checkMask(document.tcpip.mask2))
		return false;
		if (checkLan1andLan2(document.tcpip.ip, document.tcpip.mask, document.tcpip.ip2, document.tcpip.mask2) == false) {
		alert("Network Address Conflict !");
		document.tcpip.ip2.value=document.tcpip.ip2.defaultValue;
		document.tcpip.ip2.focus();
		return false;}}


	//// R01 - start
        //document.tcpip.dhcpRangeStart.disabled = false;
        //document.tcpip.dhcpRangeEnd.disabled = false;
        //document.tcpip.dhcpGateway.disabled = false;
	//// R01 - end
	//
        //document.tcpip.dhcpSubnetMask.disabled = false;
	//
        //document.tcpip.dhcpSubnetMask.value = document.tcpip.mask.value;

  if ( includeSpace(document.tcpip.dname.value)) {
		alert('Invalid domain name.');
		document.tcpip.dname.focus();
		return false;
 	}
	if (checkString(document.tcpip.dname.value) == 0) {
		alert('Invalid domain name.');
		document.tcpip.dname.focus();
		return false;
	}
	if (pool_ipprefix) {
	if (document.tcpip.WebDhcpRangeStart.value=="") {
		alert("Please input DHCP IP pool range.");
		document.tcpip.WebDhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.defaultValue;
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}
	if ( validateKey( document.tcpip.WebDhcpRangeStart.value ) == 0 ) {
		alert("Invalid DHCP client start range. It should be 1-254.");	//cathy, for  bug B018
		document.tcpip.WebDhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.defaultValue;
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}
	if ( !checkDigitRange(document.tcpip.WebDhcpRangeStart.value,1,1,254) ) {
	  	   	alert('Invalid DHCP client start range. It should be 1-254.');
		document.tcpip.WebDhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.defaultValue;
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}
	if ( !checkSubnet(document.tcpip.lan_ip.value,document.tcpip.dhcpSubnetMask.value,document.tcpip.WebDhcpRangeStart.value)) {
		alert('Invalid DHCP client start address!\nIt should be located in the same subnet of current IP address.');
		document.tcpip.WebDhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.defaultValue;
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}
	if (document.tcpip.WebDhcpRangeEnd.value=="") {
	  	alert("Please input DHCP IP pool range.");
		document.tcpip.WebDhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.defaultValue;
		document.tcpip.WebDhcpRangeEnd.focus();
		return false;
	}
	if ( validateKey( document.tcpip.WebDhcpRangeEnd.value ) == 0 ) {
		alert("Invalid DHCP client end address range. It should be 1-254.");		//cathy, for  bug B018
		document.tcpip.WebDhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.defaultValue;
		document.tcpip.WebDhcpRangeEnd.focus();
		return false;
	}
	if ( !checkDigitRange(document.tcpip.WebDhcpRangeEnd.value,1,1,254) ) {
	  	alert('Invalid DHCP client end range. It should be 1-254.');
		document.tcpip.WebDhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.defaultValue;
		document.tcpip.WebDhcpRangeEnd.focus();
		return false;
	}
	if ( !checkSubnet(document.tcpip.lan_ip.value,document.tcpip.dhcpSubnetMask.value,document.tcpip.WebDhcpRangeEnd.value)) {
		alert('Invalid DHCP client end address!\nIt should be located in the same subnet of current IP address.');
		document.tcpip.WebDhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.defaultValue;
		document.tcpip.WebDhcpRangeEnd.focus();
		return false;
	}
	if ( parseInt(document.tcpip.WebDhcpRangeStart.value, 10) >= parseInt(document.tcpip.WebDhcpRangeEnd.value, 10) ) {
		alert('Invalid DHCP client address range!\nEnding address should be greater than starting address.');
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}
	}
	else 
	{
		if (!checkHostIP(document.tcpip.WebDhcpRangeStart, 1)) {
			document.tcpip.WebDhcpRangeStart.value = document.tcpip.WebDhcpRangeStart.defaultValue;
			document.tcpip.WebDhcpRangeStart.focus();
			return false;
		}
		if (!checkHostIP(document.tcpip.WebDhcpRangeEnd, 1)) {
			document.tcpip.WebDhcpRangeEnd.value = document.tcpip.WebDhcpRangeEnd.defaultValue;
			document.tcpip.WebDhcpRangeEnd.focus();
			return false;
		}
	}
	if (!checkInputIP(document.tcpip.lan_ip.value)) {
		alert('Invalid IP pool range! LAN IP must be excluded from DHCP IP pool.');
		document.tcpip.WebDhcpRangeStart.focus();
		return false;
	}

	if ( document.tcpip.ltime.value=="") {
		alert("Please input dhcp lease time.");
		document.tcpip.ltime.focus();
		return false;
	}
	if ( validateKey_leasetime( document.tcpip.ltime.value ) == 0 ) {
		alert("Invalid DHCP Server lease time number.");
		document.tcpip.ltime.value = document.tcpip.ltime.defaultValue;
		document.tcpip.ltime.focus();
		return false;
	}
	if ( !checkDigitRange_leaseTime(document.tcpip.ltime.value, -1) ) {
	  	alert('Invalid DHCP Server lease time.');
		document.tcpip.ltime.value = document.tcpip.ltime.defaultValue;
		document.tcpip.ltime.focus();
		return false;
	}
	if (!checkHostIP(document.tcpip.ip, 1))//Dhcp GW IP
		return false;
  	
  	if (en_dnsopt && document.tcpip.dhcpdns[1].checked) {
		if (document.tcpip.dns1.value=="") {
			alert("Enter DNS value !");
			document.tcpip.dhcpdns.value = document.tcpip.dhcpdns.defaultValue;
			document.tcpip.dns1.value = document.tcpip.dns1.defaultValue;
			document.tcpip.dns1.focus();
			return false;
		}
		if (!checkHostIP(document.tcpip.dns1, 1)) {
			document.tcpip.dns1.value = document.tcpip.dns1.defaultValue;
			document.tcpip.dns1.focus();
			return false;
		}

		if (document.tcpip.dns2.value!="") {
			if (!checkHostIP(document.tcpip.dns2, 0)) {
				document.tcpip.dns2.value = document.tcpip.dns2.defaultValue;
				document.tcpip.dns2.focus();
				return false;
			}
			if (document.tcpip.dns3.value!="") {
				if (!checkHostIP(document.tcpip.dns3, 0)) {
					document.tcpip.dns3.value = document.tcpip.dns3.defaultValue;
					document.tcpip.dns3.focus();
					return false;
				}
			}
		}
	}

	// R03 - start
	document.getElementById('lan_if_set').style.display='none';
	document.getElementById('lan_if_set_msg').style.display='block';
	setTimeout("windowStop()", 10000);
	// R03 - end

	return true;
}

function disableRadioGroup (radioArrOrButton)
{
  if (radioArrOrButton.type && radioArrOrButton.type == "radio") {
 	var radioButton = radioArrOrButton;
 	var radioArray = radioButton.form[radioButton.name];
  }
  else
 	var radioArray = radioArrOrButton;
 	radioArray.disabled = true;
 	for (var b = 0; b < radioArray.length; b++) {
 	if (radioArray[b].checked) {
 		radioArray.checkedElement = radioArray[b];
 		break;
	}
  }
  for (var b = 0; b < radioArray.length; b++) {
 	radioArray[b].disabled = true;
 	radioArray[b].checkedElement = radioArray.checkedElement;
  }
}

function updateState()
{
  if (document.tcpip.wlanDisabled.value == "ON") {

    disableRadioGroup(document.tcpip.BlockEth2Wir);

  }
}

function updateInput()
{
	if (document.tcpip.enable_ip2.checked == true) {
		if (document.getElementById)  // DOM3 = IE5, NS6
			document.getElementById('secondIP').style.display = 'block';
			else {
			if (document.layers == false) // IE4
				document.all.secondIP.style.display = 'block';
		}
	} else {
		if (document.getElementById)  // DOM3 = IE5, NS6
			document.getElementById('secondIP').style.display = 'none';
		else {
			if (document.layers == false) // IE4
				document.all.secondIP.style.display = 'none';
		}
	}
}

// R01 - start
//var oldIp;
//function recIpCfg()
//{
//        oldIp = document.tcpip.ip.value;
//}

/*
 * Try to modify dhcp server configurations:
 *   dhcp start/end ip address to the same as new lan ip address
 */
//function modDhcpCfg()
//{
//        var i, j;
//        var mask = document.tcpip.mask.value;
//        var newNet = document.tcpip.ip.value;
//
//        //support simple subnet mask only
//        if (mask == "255.255.255.0")
//                mask = 3;
//        else if (mask == "255.255.0.0")
//                mask = 2;
//        else if (mask == "255.0.0.0")
//                mask = 1;
//        else
//                return;
//
//        //get the old subnet
//        for (i=0, j=0; i<oldIp.length; i++) {
//                if (oldIp.charAt(i) == '.') {
//                        j++;
//                        if (j != mask)
//                                continue;
//                        oldIp = oldIp.substring(0, i);
//                        break;
//                }
//        }
//
//        //get the new subnet
//        for (i=0, j=0; i<newNet.length; i++) {
//                if (newNet.charAt(i) == '.') {
//                        j++;
//                        if (j != mask)
//                                continue;
//                        newNet = newNet.substring(0, i);
//                        break;
//                }
//        }
//
//        document.tcpip.dhcpRangeStart.value = document.tcpip.dhcpRangeStart.value.replace(oldIp, newNet);
//        document.tcpip.dhcpRangeEnd.value = document.tcpip.dhcpRangeEnd.value.replace(oldIp, newNet);
//        document.tcpip.dhcpGateway.value = document.tcpip.ip.value;
//        //document.tcpip.dhcpGateway.value = document.tcpip.dhcpGateway.value.replace(oldIp, newNet);
//}
// R01 - end

function ChangeMask()
{
  var vSelMask = document.tcpip.SelMask.value;
  
  if(vSelMask == 0)
  {
  	document.tcpip.mask.value = "255.255.255.0";
  }
  else if(vSelMask == 1)
  {
    document.tcpip.mask.value = "255.255.255.128";
  }
  else if(vSelMask == 2)
  {
    document.tcpip.mask.value = "255.255.255.192";
  }
  else if(vSelMask == 3)
  {
    document.tcpip.mask.value = "255.255.255.224";
  }
  else if(vSelMask == 4)
  {
    document.tcpip.mask.value = "255.255.255.240";
  }
  else if(vSelMask == 5)
  {
    document.tcpip.mask.value = "255.255.255.248";
  }
  else if(vSelMask == 6)
  {
    document.tcpip.mask.value = "255.255.255.252";
  }
  
  if(document.tcpip.mask.value == "255.255.255.0")
  {
  	document.tcpip.WebDhcpRangeStart.disabled = false;
  	document.tcpip.WebDhcpRangeEnd.disabled = false;
  }
  else
  {
  	document.tcpip.WebDhcpRangeStart.disabled = true;
  	document.tcpip.WebDhcpRangeEnd.disabled = true;
  }
  calculate(document.tcpip);
}

function on_init()
{
	var vMask = '255.255.255.0';
  
  if(vMask == "255.255.255.0")
  {
  	document.tcpip.SelMask.value = 0;
  }
  else if(vMask == "255.255.255.128")
  {
    document.tcpip.SelMask.value = 1;
  }
  else if(vMask == "255.255.255.192")
  {
  document.tcpip.SelMask.value = 2;
  }
  else if(vMask == "255.255.255.224")
  {
    document.tcpip.SelMask.value = 3;
  }
  else if(vMask == "255.255.255.240")
  {
    document.tcpip.SelMask.value = 4;
  }
  else if(vMask == "255.255.255.248")
  {
    document.tcpip.SelMask.value = 5;
  }
  else if(vMask == "255.255.255.252")
  {
    document.tcpip.SelMask.value = 6;
  }  
  
  if(vMask == "255.255.255.0")
  {
  	document.tcpip.WebDhcpRangeStart.disabled = false;
  	document.tcpip.WebDhcpRangeEnd.disabled = false;
  }
  else
  {
  	document.tcpip.WebDhcpRangeStart.disabled = true;
  	document.tcpip.WebDhcpRangeEnd.disabled = true;
    calculate(document.tcpip);
  }
  
}


var pool_ipprefix;
var initialDhcp;
function skip () { this.blur(); }
function openWindow(url, windowName) {
	var wide=600;
	var high=400;
	if (document.all)
		var xMax = screen.width, yMax = screen.height;
	else if (document.layers)
		var xMax = window.outerWidth, yMax = window.outerHeight;
	else
	   var xMax = 640, yMax=480;
	var xOffset = (xMax - wide)/2;
	var yOffset = (yMax - high)/3;

	var settings = 'width='+wide+',height='+high+',screenX='+xOffset+',screenY='+yOffset+',top='+yOffset+',left='+xOffset+', resizable=yes, toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes';

	window.open( url, windowName, settings );
}

function showdns()
{
	if (document.tcpip.dhcpdns[0].checked == true) {
		if (document.getElementById)  // DOM3 = IE5, NS6
			document.getElementById('dnsset').style.display = 'none';
		else {
			if (document.layers == false) // IE4
				document.all.dnsset.style.display = 'none';
		}
	} else {
		if (document.getElementById)  // DOM3 = IE5, NS6
			document.getElementById('dnsset').style.display = 'block';
		else {
			if (document.layers == false) // IE4
				document.all.dnsset.style.display = 'block';
		}
	}
}

function showDhcpSvr(ip)
{
	var html;
	
	if (document.tcpip.dhcpdenable[0].checked == true)
  {
  	document.getElementById('displayDhcpSvr').innerHTML='&nbsp;&nbsp;';
  }
	else if (document.tcpip.dhcpdenable[1].checked == true)
	{
		document.getElementById('displayDhcpSvr').innerHTML=
			'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
			'<tr><font color="#000000" size=2>'+
			'This page is used to configure the DHCP Server IP Address for DHCP Relay.'+
			'</font></tr>'+
			'<tr><td><hr size=1 noshade align=top></td></tr>'+
			'</table>'+
			'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
			'<tr>'+
			'<td width="40%"><font size=2><b>DHCP Server IP Address:</b></font></td>'+
			'<td width="60%"><font size=2><input type="text" name="dhcps" size="18" maxlength="15" value=172.19.31.4></font></td>'+
			'</tr>'+
			'</table>';
			
  }
	else if (document.tcpip.dhcpdenable[2].checked == true) {
		html=
			'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
			'<tr><font color="#000000" size=2>'+
			'Enable the DHCP Server if you are using this device as a DHCP server. This page lists the IP address pools available to hosts on your LAN. The device distributes numbers in the pool to hosts on your network as they request Internet access.'+


			'</font></tr>'+
			'<tr><td><hr size=1 noshade align=top></td></tr>'+
			'</table>'+
			'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
			'<tr>'+
			'<td width="30%"><font size=2><b>IP Pool Range:</b></td>';

		if (pool_ipprefix)
			html+=
				'<td width="70%"><font size=2><b>'+pool_ipprefix+'<input type="text" name="WebDhcpRangeStart" size=3 maxlength=3 value="192.168.20.100">'+
				'<font face="Arial" size="5">- </font><font size=2>'+pool_ipprefix+'<input type="text" name="WebDhcpRangeEnd" size=3 maxlength=3 value="192.168.20.200">&nbsp;';
		else
			html+=
				'<td width="70%"><input type="text" name="WebDhcpRangeStart" size=15 maxlength=15 value="192.168.20.100">'+
				'<font face="Arial" size="5">- <input type="text" name="WebDhcpRangeEnd" size=15 maxlength=15 value="192.168.20.200">&nbsp;';
		html+=
			'<input type="button" value="Show Client" name="dhcpClientTbl" onClick="dhcpTblClick(\'dhcptbl.asp\')" >'+
			'</td>'+
			'</tr>';
		

		
		html += '<tr>'+
			'<td width="30%"><font size=2><b>Max Lease Time:</b></td>'+
			'<td width="70%"><font size=2>'+
			'<input type="text" name="ltime" size=10 maxlength=9 value="86400"><b> seconds</b><b> (-1 indicates an infinite lease)</b>'+
			'</td>'+
			'</tr>'+
			'<tr>'+
			'<td width="30%"><font size=2><b>Domain Name:</b></td>'+
			'<td width="70%">'+
			'<input type="text" name="dname" size=32 maxlength=29 value="NetComm.Wireless">'+
			'</td>'+
			'</tr>'+
			'<tr>'+
			'<td width="30%"><font size=2></td>'+
			'<td width="70%"><input type="hidden" name="ip" size="15" maxlength="15" value=192.168.20.1></td>'+
			'</tr>'+
			'</table>';


		if (1)
			html +=
				'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
				'<tr>'+
					'<td width="30%"><font size=2><b>option 60(Network):</b></td>'+
					'<td width="70%">'+
					'<input type="text" name="opt60name1" size=32 maxlength=29 value="network_id">'+
					'</td>'+
				'</tr>'+
				'<tr>'+
					'<td width="30%"><font size=2><b>option 60(Local):</b></td>'+
					'<td width="70%">'+
					'<input type="text" name="opt60name2" size=32 maxlength=29 value="local_id">'+
					'</td>'+
				'</tr>'+
				'</table>';


		if (en_dnsopt == 0)
			html += '<div ID=optID style="display:none">';
		else
		{
			html += '<div ID=optID style="display:block">';

		html +=
			'<table border=0 width="500" cellspacing=4 cellpadding=0><tr>'+
			'<td width="30%"><font size=2><b>DNS option:</b></td>'+
			'<td width=70%><input type=radio name=dhcpdns value=0 onClick=showdns()>Use DNS Relay&nbsp;&nbsp;'+
			'<input type=radio name=dhcpdns value=1 onClick=showdns()>Set Manually&nbsp;&nbsp;</td>'+
			'</tr></table></div>'+
			'<div ID=dnsset style="display:none">'+
			'<table border=0 width="500" cellspacing=4 cellpadding=0>'+
			'<tr><td width=30%><b>DNS1:</b></td><td width=70%><input type=text name=dns1 value=></td></tr>'+
			'<tr><td width=30%><b>DNS2:</b></td><td width=70%><input type=text name=dns2 value=></td></tr>'+
			'<tr><td width=30%><b>DNS3:</b></td><td width=70%><input type=text name=dns3 value=></td></tr></table></div>'+
			'<input type="button" value="Port-Based Filter" name="macIpTbl" onClick="macIpClick(\'portBaseFilterDhcp.asp\')">'+

			'<input type="button" value="MAC-Based Assignment" name="macIpTbl" onClick="macIpClick(\'macIptbl.asp\')">';
    }
		if (0)
			html +=
			'<input type="button" value="STB Data Pool" name="macIpTbl" onClick="macIpClick(\'stbDataIptbl.asp\')">';


		document.getElementById('displayDhcpSvr').innerHTML=html;
		if (en_dnsopt) {
			document.tcpip.dhcpdns[dnsopt].checked = true;
			showdns();
		}
	}
}

function checkInputIP(ip)
{
	var i, ip_d;
	for (i=1; i<5; i++) {
		ip_d = getDigit(ip, i);
	}
	if ((ip_d >= parseInt(document.tcpip.WebDhcpRangeStart.value, 10)) && (ip_d <= parseInt(document.tcpip.WebDhcpRangeEnd.value, 10))) {
		return false;
	}
	return true;
}

function saveClick()
{
	if (!checkHostIP(document.tcpip.dhcps, 1)) {
  		return false;
  	}
	return true;
}

function checkSubnet(ip, mask, client)
{
  ip_d = getDigit(ip, 4);
  mask_d = getDigit(mask, 4);
  if ( (ip_d & mask_d) != (client & mask_d ) )
	return false;

  return true;
}

function checkDigitRange_leaseTime(str, min)
{
  d = parseInt(str, 10);
  if ( d < min || d == 0)
      	return false;
  return true;
}

function validateKey_leasetime(str)
{
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') ||
    		(str.charAt(i) == '-' ) )
			continue;
	return 0;
  }
  return 1;
}


function dhcpTblClick(url) {
	openWindow(url, 'DHCPTbl' );
}

function ShowIP2(ipVal) {
	document.write(getDigit(ipVal,1));
	document.write('.');
	document.write(getDigit(ipVal,2));
	document.write('.');
	document.write(getDigit(ipVal,3));
	document.write('.');
}

function ShowIP(ipVal) {

	var str;

	str = getDigit(ipVal, 1) + '.';
	str += getDigit(ipVal, 2) + '.';
	str += getDigit(ipVal, 3) + '.';

	return str;
}

function macIpClick(url)
{
	var wide=600;
	var high=400;
	if (document.all)
		var xMax = screen.width, yMax = screen.height;
	else if (document.layers)
		var xMax = window.outerWidth, yMax = window.outerHeight;
	else
	   var xMax = 640, yMax=480;
	var xOffset = (xMax - wide)/2;
	var yOffset = (yMax - high)/3;

	var settings = 'width='+wide+',height='+high+',screenX='+xOffset+',screenY='+yOffset+',top='+yOffset+',left='+xOffset+', resizable=yes, toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes';

	window.open( url, 'MACIPTbl', settings );
}

function enabledhcpd()
{
	document.tcpip.dhcpdenable[2].checked = true;
	//ip = ShowIP(document.tcpip.lan_ip.value);
	showDhcpSvr(pool_ipprefix);
}

function disabledhcpd()
{
	document.tcpip.dhcpdenable[0].checked = true;
	showDhcpSvr();
}

function enabledhcprelay()
{
	document.tcpip.dhcpdenable[1].checked = true;
	showDhcpSvr();
}

//Javascript IP subnet calculator sssssssss
function calculate(form) {

/* Input */
var ipaddress = (form.webLanIp.value);
var smmask = (form.mask.value)

/* Check for valid characters */

var validchars = "0123456789.";
var test = false;
for (i=0; i<ipaddress.length; i++) {
var c = 0; 
test = false;
while ((c<11) && (test == false)){
if (ipaddress.charAt(i) == validchars.charAt(c)){
test = true};
c = c+1;
}   
if (test == false){form.reportbox.value = "Invalid address. IP addresses may only contain numbers and full-stops."; return;};
}		

for (i=0; i<smmask.length; i++) {
var c = 0; 
test = false;
while ((c<11) && (test == false)){
if (smmask.charAt(i) == validchars.charAt(c)){
test = true};
c = c+1;
}   
if (test == false){form.reportbox.value = "Invalid subnet mask. Subnet masks may only contain numbers and full-stops."; return;};
}

/* Strip numerical data from input string */

var dotpos = new Array(3);
dotpos[0] = 0;
dotpos[1] = 0;
dotpos[2] = 0;    
var c = -1;   
for (i = 0; i < ipaddress.length; i++){
if (ipaddress.charAt(i) == "."){
c = ( c + 1);	   
dotpos[c] = i + 1;
}
}

var val1 = parseInt(ipaddress.substring(0,dotpos[0]),10);
var val2 = parseInt(ipaddress.substring(dotpos[0],dotpos[1]),10);
var val3 = parseInt(ipaddress.substring(dotpos[1],dotpos[2]),10);
var val4 = parseInt(ipaddress.substring(dotpos[2],ipaddress.length),10);

dotpos[0] = 0;
dotpos[1] = 0;
dotpos[2] = 0;    
var c = -1;   
for (i = 0; i < smmask.length; i++){   
if (smmask.charAt(i) == "."){
c = ( c + 1);	   
dotpos[c] = i + 1;
}            		
}

var val5 = parseInt(smmask.substring(0,dotpos[0]),10);
var val6 = parseInt(smmask.substring(dotpos[0],dotpos[1]),10);
var val7 = parseInt(smmask.substring(dotpos[1],dotpos[2]),10);
var val8 = parseInt(smmask.substring(dotpos[2],smmask.length),10);  


/* Initialize fields */

form.WebDhcpRangeStart.value = "0.0.0.0"
form.WebDhcpRangeEnd.value = "0.0.0.0"
form.numofhosts.value = "0"
form.subnetaddress.value = "0.0.0.0"
form.broadcastaddress.value = "0.0.0.0"
form.networkclass.value = "-"
form.subsizebits.value = "0"
form.hostsizebits.value = "0"

/* Declaration of variables */

var val9 = val1
var val10 = 0  
var val11 = 0
var val12 = 0   
var val13 = val1
var val14 = 0   
var val15 = 0
var val16 = 0
var val17 = "-" 
var x = 0
var ipdec = 0
var smdec = 0 
var startdec = 0
var enddec = 0
var message1 = "Dotted decimal values must be between 0 and 255"
var message2 = "The subnet mask is invalid"
var message3 = "The IP address is unusable as a host address with this subnet mask"
var message4 = "The subnet mask is invalid"
var message5 = "The IP address is invalid"
var message6 = " "
var message7 = "IP addresses of type 127.x.x.x are unusable as host addresses"    
var message9 = "Note: "+val1+"."+val2+"."+val3+"."+val4+" is a class B IP address and is normally used with a subnet mask of type 255.255.x.x"
var message10 = "Note: "+val1+"."+val2+"."+val3+"."+val4+" is a class C IP address and is normally used with a subnet mask of type 255.255.255.x"
var message11 = "";
var message12 = "IP addresses of type 0.x.x.x are unusable as host addresses"
var message13 = "This is a class D address. It is unusable as a host address."
var message14 = "This is a class E address. It is unusable as a host address."   
var output = message11



/* Input validation */

if (val1 == 127){form.reportbox.value = message7;return}; 
if (val1 == 0){form.reportbox.value = message12;return};

if ((val1 > 255) || (val2 > 255) || (val3 > 255) || (val4 > 255)
|| (val5 > 255) || (val6 > 255) || (val7 > 255) || (val8 > 255))
{form.reportbox.value = message1; return};      

if (val5 != 255){form.reportbox.value = message2;return};

if ((val6!=00)&&(val6!=128)&&(val6!=192)&&(val6!=224)&&(val6!=240)&&(val6!=248)&&(val6!=252)&&(val6!=254)&&(val6!=255)){form.reportbox.value = message2;return};   
if ((val7!=00)&&(val7!=128)&&(val7!=192)&&(val7!=224)&&(val7!=240)&&(val7!=248)&&(val7!=252)&&(val7!=254)&&(val7!=255)){form.reportbox.value = message2;return};
if ((val8!=00)&&(val8!=128)&&(val8!=192)&&(val8!=224)&&(val8!=240)&&(val8!=248)&&(val8!=252)&&(val8!=254)&&(val8!=255)){form.reportbox.value = message2;return};      

if (val6!=255){if ((val7!=0)||(val8!=0)){form.reportbox.value = message4;return}};
if (val7!=255){if (val8!=0){form.reportbox.value = message4;return}};
if (val8> 252){form.reportbox.value = message4;return};

/* Conversion from dotted decimal notation to decimal */

smdec = (val6 * 65536) + (val7 * 256) + val8;
ipdec = (val2 * 65536) + (val3 * 256) + val4;

/* Determination of network address size (n) */

for (t = 2; t < 25; t = t + 1)
{if (smdec == (16777216 - Math.pow(2,t))) 
{(n = 32 - t)}}

/* Determination of network class */

if (val1 < 127) {val17 = "A"}
if ((val1 > 127) && (val1 < 192)) {val17 = "B"}
if ((val1 > 191) && (val1 < 224)) {val17 = "C"} 
if ((val1 > 223) && (val1 < 240)) {val17 = "D"}
if ((val1 > 239) && (val1 < 256)) {val17 = "E"}

/* Validation of IP address according to class */

if ((val17 == "B") && (n <16)){output = message9};
if ((val17 == "C") && (n <24)){output = message10};
if (val17 == "D"){form.reportbox.value = message13; return};
if (val17 == "E"){form.reportbox.value = message14; return};

/* Calculation of range for n >23 */

if (n > 23){
x = Math.pow(2,(32 - n));
for (i = - 1;  i < (256 - x);  i = (i + x))
{if ((val4 >= (i + 1)) && (val4 <= (i + x))) 
{val12 = (i + 2);
val16 = (i + (x - 1));
}     
}   
val10 = val2
val11 = val3
val14 = val2
val15 = val3   
if ((String(String(val2)+val3+(val4)) == String(String(val10)+val11+(val12 - 1))) || (String(String(val2)+val3+(val4)) == String(String(val14)+val15+(val16 + 1))))
{output = "WARNING:IP address "+val1+"."+val2+"."+val3+"."+val4+" is unusable as a host address with subnet mask "+val5+"."+val6+"."+val7+"."+val8};
}  

/* Calculation of range for n >=16 AND <24 */

if ((n >= 16) && (n < 24)){
x = Math.pow(2,(24 - n)); 
for (i = 0;  i <= (256 - x);  i = (i + x))
{if ((val3 >= (i)) && (val3 <= (i + x))) 
{val11 = (i);
val15 = (i + (x - 1));
}
}
val10 = val2
val14 = val2
val12 = 1
val16 = 254
if ((String(String(val2)+val3+(val4)) == String(String(val10)+val11+(val12 - 1))) || (String(String(val2)+val3+(val4)) == String(String(val14)+val15+(val16 + 1))))
{output = "WARNING:IP address "+val1+"."+val2+"."+val3+"."+val4+" is unusable as a host address with subnet mask "+val5+"."+val6+"."+val7+"."+val8};
}

/* Calculation of range for n >=8 AND <16 */

if ((n >= 8) && (n < 16)){
x = Math.pow(2,(16 - n));
for (i = 0;  i <= (256 - x);  i = (i + x))
{if ((val2 >= (i)) && (val2 <= (i + x))) 
{val10 = (i);
val14 = (i + (x - 1));
}
}
val11 = 0
val15 = 255
val12 = 1
val16 = 254
if ((String(String(val2)+val3+(val4)) == String(String(val10)+val11+(val12 - 1))) || (String(String(val2)+val3+(val4)) == String(String(val14)+val15+(val16 + 1))))
{output = "WARNING:IP address "+val1+"."+val2+"."+val3+"."+val4+" is unusable as a host address with subnet mask "+val5+"."+val6+"."+val7+"."+val8};
}     

/* Conversion back to dotted decimal notation 

val15 = Math.floor(startdec/65536)
val16 = Math.floor((startdec % 65536)/256)
val11 = Math.floor(startdec % 256)
val12 = Math.floor(enddec/65536)
val13 = Math.floor((enddec % 65536)/256)
val14 = Math.floor(enddec % 256)           */

//Only in 255.255.255.0 case and IP is x.x.x.1 then IP pool start from x.x.x.2.
//val4 = ipaddress last digi 
if(smmask =="255.255.255.0" && val4 =="1")
{
	val12 = "2";
}

/* Output */

form.WebDhcpRangeStart.value = val9+"."+val10+"."+val11+"."+val12;
form.WebDhcpRangeEnd.value = val13+"."+val14+"."+val15+"."+val16;
form.numofhosts.value = (Math.pow(2,(32 - n))-2);
form.subnetaddress.value = val9+"."+val10+"."+val11+"."+((val12)-1);
form.broadcastaddress.value = val13+"."+val14+"."+val15+"."+((val16)+1);
form.subsizebits.value = n;
form.hostsizebits.value = 32 - n;
form.networkclass.value = val17;
form.reportbox.value = output;

}
//Javascript IP subnet calculator eeeeeeeee


function StrContains(vSource, vTarget)
{
  return (vSource.indexOf(vTarget) > -1);
}


function GetIpSegment123(ipaddress) {

/* Input */


/* Check for valid characters */

var validchars = "0123456789.";
var test = false;
for (i=0; i<ipaddress.length; i++) {
var c = 0; 
test = false;
while ((c<11) && (test == false)){
if (ipaddress.charAt(i) == validchars.charAt(c)){
test = true};
c = c+1;
}   
if (test == false){form.reportbox.value = "Invalid address. IP addresses may only contain numbers and full-stops."; return;};
}		


/* Strip numerical data from input string */

var dotpos = new Array(3);
dotpos[0] = 0;
dotpos[1] = 0;
dotpos[2] = 0;    
var c = -1;   
for (i = 0; i < ipaddress.length; i++)
{   
  if (ipaddress.charAt(i) == ".")
  {
    c = ( c + 1);	   
    dotpos[c] = i + 1;
  }   		
}


var val1 = parseInt(ipaddress.substring(0,dotpos[0]),10);
var val2 = parseInt(ipaddress.substring(dotpos[0],dotpos[1]),10);
var val3 = parseInt(ipaddress.substring(dotpos[1],dotpos[2]),10);
var val4 = parseInt(ipaddress.substring(dotpos[2],ipaddress.length),10);

return val1+"."+val2+"."+val3+".";

}

</SCRIPT>
</head>

<!-- <body> -->
<body onload="on_init();">

<blockquote>
<div id="lan_if_set" style="display:block"><!-- R03 -->
<H2>LAN Interface Settings</H2>

<!--<form action=/boaform/formTcpipLanSetup method=POST name="tcpip">-->
<form action=tcpiplan.asp method=POST name="tcpip">

<table border=0 width="500" cellspacing=4 cellpadding=0>
  <tr><td><font size=2>
    This page is used to configure the LAN interface of your Router. Here you may change the setting for IP addresses, subnet mask, etc..
  </font></td></tr>
  <tr><td><hr size=1 noshade align=top></td></tr>
</table>
<table border=0 width="500" cellspacing=4 cellpadding=0>
	<input type=hidden name="wlanDisabled" value="OFF">
  <!--
  <tr>
      <td width="30%"><font size=2><b>Interface Name:</b></td>
      <td width="70%"><b>br0</b></td>
  </tr>
  -->

  <tr>
      <td width="30%"><font size=2><b>IP Address:</b></td>

      <!-- R01
      <td width="70%"><input type="text" name="ip" size="15" maxlength="15" value=192.168.20.1></td>
      -->
      <!-- R01 - start -->
      <!-- R04 <td width="70%"><input type="text" name="ip" size="15" maxlength="15" value=< % getInfo("lan-ip"); % > onfocus="recIpCfg()" onblur="modDhcpCfg()"></td> -->
      <!-- <td width="70%"><input type="text" name="ip" size="15" maxlength="15" value=192.168.20.1 onfocus="recIpCfg()"></td> --> <!-- R04 -->
      <!-- R01 - end -->
      <td width="70%"><input type="text" name="webLanIp" size="15" maxlength="15" value=192.168.20.1 ></td>
  </tr>

  <!--
  <tr>
      <td width="30%"><font size=2><b>Subnet Mask:</b></td>
      <td width="70%"><input type="text" name="mask" size="15" maxlength="15" value="255.255.255.0"></td>
  </tr>
  -->

  <!-- for formTcpipLanSetup() & formDhcpd() buffer sssss -->
  <input type="hidden" name="dhcpSubnetMask" value="255.255.255.0">
  <input type="hidden" name="mask" value="255.255.255.0">
  
  <!-- 
  Hill request if user select !=255.255.255.0 then disable <input name="dhcpRangeStart">,
  but if disable <input name="dhcpRangeStart"> the formTcpipLanSetup() can't get value,
  so i must create a new <input name="WebDhcpRangeStart"> for display.
  When user click "Apply Changes" then <input name="WebDhcpRangeStart"> copy to <input name="dhcpRangeStart">
   -->
  <input type="hidden" name="dhcpRangeStart" value="192.168.20.100">
  <input type="hidden" name="dhcpRangeEnd" value="192.168.20.200">
  <!-- for formTcpipLanSetup() & formDhcpd() buffer eeeee -->
  
  <tr>
      <td width="30%"><font size=2><b>Subnet Mask:</b></td>
		  <td width="70%">
		  <select size="1" id="SelMask" onchange="ChangeMask()">
	    <option selected="0" value="0">255.255.255.0</option>
	    <option value="1">255.255.255.128</option>
      <option value="2">255.255.255.192</option>
      <option value="3">255.255.255.224</option>
      <option value="4">255.255.255.240</option>
      <option value="5">255.255.255.248</option>
      <option value="6">255.255.255.252</option>
      </select>
		  </td>
	</tr>	

	<tr id="trMaskRangeBuffer" style="display:none;">
	<td>
  <input type="button" value="Calculate" name="submitButtonName" onclick="calculate(this.form)">
  <input type="reset" value=" Reset ">
  <input type="text" value="0" name="numofhosts" size="9" maxlength="15">
  <input type="text" value="0.0.0.0" name="subnetaddress" size="15" maxlength="15">
  <input type="text" value="0.0.0.0" name="broadcastaddress" size="15" maxlength="15">
  <input type="text" value="-" name="networkclass" size="1" maxlength="1">
  <input type="text" value="0" name="subsizebits" size="2" maxlength="2">
  <input type="text" value="0" name="hostsizebits" size="2" maxlength="2">
  </td>
  <td width="355" valign="middle" align="left" colspan="2" rowspan="5" content="" csheight="22"><span class="bold">Additional Information</span>
  <p><textarea name="reportbox" cols="33" rows="7" wrap="virtual"> </textarea></p>
  </td>
  </tr>

    <tr></tr><tr></tr>
  </table>
    <tr>
<td><font size=2>
<input type=checkbox name=enable_ip2 value=1 onClick=updateInput()>&nbsp;&nbsp;<b>Secondary IP</b>
</td></tr>
<div ID="secondIP" style="display:none">
<table border=0 width="500" cellspacing=4 cellpadding=0>
<tr><td width=150><font size=2><b>IP Address:</b></td>
<td width=350><input type=text name=ip2 size=15 maxlength=15 value=192.168.100.1></td>
</tr>
<tr><td><font size=2><b>Subnet Mask:</b></td>
<td><input type=text name=mask2 size=15 maxlength=15 value=255.255.255.0></td>
</tr>
</table></div>
<table border=0 width="500" cellspacing=4 cellpadding=0>
<tr><td width=150><font size=2><b>IGMP Snooping:</b></td>
<td width=350><font size=2>
<input type="radio" name=snoop value=1>Enabled&nbsp;&nbsp;
<input type="radio" name=snoop value=0>Disabled</td>
</tr></table>
<table border=0 width="500" cellspacing=4 cellpadding=0>
<tr><td width=150><font size=2><b>Ethernet to Wireless Blocking:</b></td>
<td width=350><font size=2>
<input type="radio" name=BlockEth2Wir value=1>Enabled&nbsp;&nbsp;
<input type="radio" name=BlockEth2Wir value=0>Disabled</td></tr></table>

  <br>

<!-- R01 - start -->
<!--
<div id="display_none" style="display:none">
<table border=0 width="500" cellspacing=4 cellpadding=0>
  <tr>
      <td width="30%"><font size=2><b>Start IP Address:</b></td>
      <td width="70%"><input type="text" name="dhcpRangeStart" size="15" maxlength="15" value="192.168.20.100" disabled="true"></td>
  </tr>
  <tr>
      <td width="30%"><font size=2><b>End IP Address:</b></td>
      <td width="70%"><input type="text" name="dhcpRangeEnd" size="15" maxlength="15" value="192.168.20.200" disabled="true"></td>
  </tr>
  <tr>
      <td width="30%"><font size=2><b>Gateway Address:</b></td>
      <td width="70%"><input type="text" name="dhcpGateway" size="15" maxlength="15" value="192.168.20.1" disabled="true"></td>
  </tr>
  <tr>
      <td width="30%"><font size=2><b>Subnet Mask:</b></td>
      <td width="70%"><input type="text" name="dhcpSubnetMask" size="15" maxlength="15" value="255.255.255.0" disabled="true"></td>
  </tr>
</table>
</div>
-->
<!-- R01 - end -->

<div id="divDhcpd" style="display:table-row;">
<input type="hidden" name="lan_ip" value=192.168.20.1>
<table border=0 width="500" cellspacing=4 cellpadding=0>
  <tr><td><font color="#000000" size=2>
  </font></td></tr>
  <tr><td><hr size=1 noshade align=top></td></tr>
</table>

<table border=0 width="500" cellspacing=4 cellpadding=0>
  <tr>
  <td><font size=2><b>DHCP Mode: </b>
  <input type="radio" name=dhcpdenable value=0 onClick="disabledhcpd()">None&nbsp;&nbsp;
<input type="radio"name=dhcpdenable value=1 onClick="enabledhcprelay()">DHCP Relay&nbsp;&nbsp;
<input type="radio"name=dhcpdenable value=2 onClick="enabledhcpd()">DHCP Server&nbsp;&nbsp;

  </td>
  </tr>
</table>

<table border="0" width="500" cellpadding="0" cellspacing="0">
  <tr><td><hr size=2 noshade align=top></td></tr>
  <tr><td ID="displayDhcpSvr"></td></tr>
</table>

   <br>

<script>
	pool_ipprefix='';
  en_dnsopt=1;
  
  dnsopt = 0;
  var vMIB_DHCP_MODE = 2;
  document.tcpip.dhcpdenable[vMIB_DHCP_MODE].checked = true;
	
	showDhcpSvr(pool_ipprefix);
</script>
</div>

      <input type="submit" value="Apply Changes" name="save" onClick="return saveChanges()">&nbsp;&nbsp;
      <!--input type="reset" value="Undo" name="reset" onClick="resetClick()"-->
      <input type="hidden" value="/tcpiplan.asp" name="submit-url">
<script>
	updateInput();
document.tcpip.snoop[1].checked = true;
document.tcpip.BlockEth2Wir[1].checked = true;

	updateState();
</script>
</form>
</div> <!-- R03 -->

<!-- R03 - start -->
<div id="lan_if_set_msg" style="display:none">
<table border=0 width="500" cellspacing=4 cellpadding=0>
<tr>
  <td>
    <font size=2>
<!--
The DSL Router has been configured. 

Close the DSL Router Configuration window and wait for 10 seconds before reopening your web brower. 
If necessary, reconfigure your PC's IP address to match your new configuration. 
-->
<b>The LAN IP address of Modem is changed, please wait for 10 seconds, <br>
unplug the network cable and plug it, PC will get new IP address.</b>
    </font>
  </td>
</tr>
</table>
</div>
<!-- R03 - end -->

</blockquote>
</body>

</html>
